# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7669 (bugzilla)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64471);
 script_cve_id("CVE-2009-1213");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 10 FEDORA-2009-7669 (bugzilla)");

 desc = "The remote host is missing an update to bugzilla
announced via advisory FEDORA-2009-7669.

Update Information:

New upstream version fixing Unauthorized Bug Change flaw:
http://www.bugzilla.org/security/3.2.3/
https://bugzilla.mozilla.org/show_bug.cgi?id=495257

ChangeLog:

* Wed Jul  8 2009 Itamar Reis Peixoto  - 3.2.4-1
- fix https://bugzilla.mozilla.org/show_bug.cgi?id=495257
* Mon Apr  6 2009 Itamar Reis Peixoto  3.2.3-1
- fix CVE-2009-1213
* Thu Mar  5 2009 Itamar Reis Peixoto  3.2.2-2
- fix from BZ #474250 Comment #16, from Chris Eveleigh -->
- add python BR for contrib subpackage
- fix description
- change Requires perl-SOAP-Lite to perl(SOAP::Lite) according guidelines

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bugzilla' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7669

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-7669 (bugzilla)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bugzilla", rpm:"bugzilla~3.2.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-contrib", rpm:"bugzilla-contrib~3.2.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bugzilla-doc", rpm:"bugzilla-doc~3.2.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
