# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-12813 (gcc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66588);
 script_cve_id("CVE-2009-3736");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.9");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 12 FEDORA-2009-12813 (gcc)");

 desc = "The remote host is missing an update to gcc
announced via advisory FEDORA-2009-12813.

ChangeLog:

* Tue Dec 22 2009 Jakub Jelinek  4.4.2-20
- fix MEM_SIZE of reload created stack slots (#548825,
PR rtl-optimization/42429)
- fix addition of one character long filenames in fastjar (#549493)

References:

[ 1 ] Bug #537941 - CVE-2009-3736 libtool: libltdl may load and execute code from a library in the current directory
https://bugzilla.redhat.com/show_bug.cgi?id=537941

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gcc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-12813

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-12813 (gcc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cpp", rpm:"cpp~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc", rpm:"gcc~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-c++", rpm:"gcc-c++~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-gfortran", rpm:"gcc-gfortran~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-gnat", rpm:"gcc-gnat~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-java", rpm:"gcc-java~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-objc", rpm:"gcc-objc~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-objc++", rpm:"gcc-objc++~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgcc", rpm:"libgcc~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgcj", rpm:"libgcj~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgcj-devel", rpm:"libgcj-devel~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgcj-src", rpm:"libgcj-src~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgfortran", rpm:"libgfortran~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnat", rpm:"libgnat~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnat-devel", rpm:"libgnat-devel~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgomp", rpm:"libgomp~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmudflap", rpm:"libmudflap~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmudflap-devel", rpm:"libmudflap-devel~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libobjc", rpm:"libobjc~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libstdc++", rpm:"libstdc++~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libstdc++-devel", rpm:"libstdc++-devel~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libstdc++-docs", rpm:"libstdc++-docs~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gcc-debuginfo", rpm:"gcc-debuginfo~4.4.2~20.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
