# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1974-1 (gzip)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66771);
 script_cve_id("CVE-2009-2624", "CVE-2010-0001", "CVE-2006-4334");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1974-1 (gzip)");

 desc = "The remote host is missing an update to gzip
announced via advisory DSA 1974-1.

Several vulnerabilities have been found in gzip, the GNU compression
utilities. The Common Vulnerabilities and Exposures project identifies
the following problems:

CVE-2009-2624

Thiemo Nagel discovered a missing input sanitation flaw in the way gzip
used to decompress data blocks for dynamic Huffman codes, which could
lead to the execution of arbitrary code when trying to decompress a
crafted archive. This issue is a reappearance of CVE-2006-4334 and only
affects the lenny version.

CVE-2010-0001

Aki Helin discovered an integer underflow when decompressing files that
are compressed using the LZW algorithm. This could lead to the execution
of arbitrary code when trying to decompress a crafted LZW compressed
gzip archive.


For the stable distribution (lenny), these problems have been fixed in
version 1.3.12-6+lenny1.

For the oldstable distribution (etch), these problems have been fixed in
version 1.3.5-15+etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems will be fixed soon.


We recommend that you upgrade your gzip packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201974-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1974-1 (gzip)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gzip", ver:"1.3.5-15+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gzip-win32", ver:"1.3.12-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"gzip", ver:"1.3.12-6+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
