##################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  Ref : Marc <marc@EEYE.COM>
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
##################################################################################
if(description)
{
  script_id(14586);
  script_bugtraq_id(217);
  script_cve_id("CVE-1999-0362");
  script_version ("$Revision: 2750 $");
  script_name(english:"WS FTP CWD DoS");
  desc["english"] = "
  According to its version number, your remote WS_FTP server is vulnerable to a
  denial of service.
  A logged attacker submitting a 'CWD' command along with arbitrary characters
  will deny the ftp service.

  ** OpenVAS only checked the version number in the server banner

  Solution : Upgrade to the latest version
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check WS_FTP server version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"FTP");
  script_dependencie("find_service.nes");
  script_require_ports("Services/ftp", 21);
  exit(0);
}


include ("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(! get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port);
if(!banner){
  exit(0);
}
# Checking for the WS_FTP Server 1.0.2
if(egrep(pattern:"WS_FTP Server 1\.0\.[0-2][^0-9]", string: banner)){
  security_warning(port);
}
