# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-776-1 (kvm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63998);
 script_cve_id("CVE-2008-1945", "CVE-2008-2004", "CVE-2008-2382", "CVE-2008-4539", "CVE-2008-5714");
 script_version ("$");
 name["english"] = "Ubuntu USN-776-1 (kvm)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to kvm
announced via advisory USN-776-1.

Details follow:

Avi Kivity discovered that KVM did not correctly handle certain disk
formats.  A local attacker could attach a malicious partition that
would allow the guest VM to read files on the VM host. (CVE-2008-1945,
CVE-2008-2004)

Alfredo Ortega discovered that KVM's VNC protocol handler did not
correctly validate certain messages.  A remote attacker could send
specially crafted VNC messages that would cause KVM to consume CPU
resources, leading to a denial of service. (CVE-2008-2382)

Jan Niehusmann discovered that KVM's Cirrus VGA implementation over VNC
did not correctly handle certain bitblt operations.  A local attacker
could exploit this flaw to potentially execute arbitrary code on the VM
host or crash KVM, leading to a denial of service. (CVE-2008-4539)

It was discovered that KVM's VNC password checks did not use the correct
length.  A remote attacker could exploit this flaw to cause KVM to crash,
leading to a denial of service. (CVE-2008-5714)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  kvm                             1:62+dfsg-0ubuntu8.1

Ubuntu 8.10:
  kvm                             1:72+dfsg-1ubuntu6.1

After a standard system upgrade you need to restart all KVM VMs to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-776-1

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Ubuntu USN-776-1 (kvm)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Ubuntu Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kvm-source", ver:"62+dfsg-0ubuntu8.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvm", ver:"62+dfsg-0ubuntu8.1", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvm-source", ver:"72+dfsg-1ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kvm", ver:"72+dfsg-1ubuntu6.1", rls:"UBUNTU8.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
