################################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
#  (C) Tenable Network Security
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
#
#  Ref: iDEFENSE 10.11.04
#
# This script is released under the GNU GPL v2
#
################################################################################
if(description)
{
  script_id(15463);
  script_bugtraq_id(11385);
  script_cve_id("CVE-2004-0918");
  script_version ("$Revision: 3038 $");
  script_name(english:"Squid remote denial of service");
  desc["english"] = "
  The remote squid caching proxy, according to its version number, may be 
  vulnerable to a remote denial of service.
  This flaw is caused due to an input validation error in the SNMP module.
  An attacker can exploit this flaw to crash the server with a specially
  crafted UDP packet.
  Solution : Upgrade to squid 2.5.STABLE7 or newer
  Risk factor : High";
 
  script_description(english:desc["english"]);
 
  script_summary(english: "Determines squid version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"Denial of Service");
  script_dependencie("find_service.nes");
  script_dependencie("secpod_squid_detect.nasl");
  script_require_ports("Services/http_proxy",3128, 8080);
  exit(0);
}


include("http_func.inc");

port = get_kb_item("Services/http_proxy");
if(!port){
  port = 3128;
}

if(!get_port_state(port)){
  port = 8080;
}

data =get_kb_item(string("www/", port, "/Squid"));
if(!data){
  exit(0);
}

if(egrep(pattern:"2\.([0-4]|5\.STABLE[0-6])", string:data))
{  security_hole(port);
   exit(0);
}
