###################################################################################
#
# This script was written by Adam Baldwin <adamb@amerion.net>
#
# Updated: 04/07/2009
# Antu Sanadi <santu@secpod.com>
# See the Nessus Scripts License for details
#
#################################################################################
if(description)
{
  script_id(10768);
  script_bugtraq_id(3354);
  script_cve_id("CVE-2001-0843");
  script_version ("$Revision: 3038 $");
  script_name(english:"DoSable squid proxy server");
  desc["english"] = "
  A problem exists in the way the remote Squid proxy server handles a
  special 'mkdir-only' PUT request, and causes denial of service to the proxy
  server.
  An attacker may use this flaw to prevent your LAN users from accessing
  the web.

  Solution:Apply the vendor released patch, for squid it is located here:
  www.squid-cache.org.  You can also protect yourself by enabling access lists
  on your proxy.

  Risk factor : Medium / High";
  script_description(english:desc["english"]);
  script_summary(english:"Determines via ver. if a proxy server is DoSable");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");
  script_copyright(english:"This script is Copyright (C) 2001 Adam Baldwin");
  script_dependencies("secpod_squid_detect.nasl");
  exit(0);
}


include("version_func.inc");

port = get_kb_item("Services/http_proxy");
if(!port){
  port = 3128;
}

if(!get_port_state(port)){
  port = 8080;
}

data =get_kb_item(string("www/", port, "/Squid"));
if(!data){
  exit(0);
}

# checking for the Version < =2.4
if(("2.3"  >< data) && (("STABLE1" >< data)||("STABLE3" >< data)||
    ("STABLE4" >< data)||("STABLE5" >< data)))
{
  security_warning(port);
  exit(0);      
}

#CHECK VERSION 2.4
if(("2.4" >< data) && (("STABLE1" >< data) ||("PRE-STABLE2" >< data) || 
   ("PRE-STABLE" >< data) ||("DEVEL4" >< data)||("DEVEL2" >< data)))
{
  security_warning(port);
  exit(0);                                                                                                              
}

