#
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# GNU Public Licence
#

if(description)
{
 script_id(16024);
 script_bugtraq_id(2897);
 script_cve_id("CVE-1999-0145");
 script_xref(name:"OSVDB", value:"1877");
 script_version ("$Revision: 3477 $");
 
 name["english"] = "Sendmail WIZ";
 script_name(english:name["english"]);

 desc["english"] = "
Your MTA accepts the WIZ command. It must be a very old version
of sendmail.
WIZ allows remote users to execute arbitrary commands as root
without the need to log in.

Solution : reconfigure it or upgrade your MTA.

Risk factor : High"; 
	

 script_description(english:desc["english"]);
		    
 
 summary["english"] = "Checks for sendmail WIZ command"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 
 family["english"] = "SMTP problems";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "smtpserver_detect.nasl", "smtpscan.nasl");
 script_require_keys("SMTP/sendmail");
 script_exclude_keys("SMTP/wrapped");

 script_require_ports("Services/smtp", 25);
 
 exit(0);
}

#

include("smtp_func.inc");

port = get_kb_item("Services/smtp");
if(! port) port = 25;
if(! get_port_state(port)) exit(0);
# if (get_kb_item("SMTP/wrapped")) exit(0);

soc = open_sock_tcp(port);
if(! soc) exit(0);
b = smtp_recv_banner(socket:soc);
if ( ! b || "Sendmail" >!< b ) exit(0);
s = string("WIZ\r\n");
# We could also test the "KILL" function, which is related to WIZ if I
# understood correctly
send(socket:soc, data:s);
r = recv_line(socket:soc, length:1024);
if(ereg(string: r, pattern: "^2[0-9][0-9]")) security_hole(port);
close(soc);

