##############################################################################
#
#  ProFTPD Long Command Handling Security Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/25
#
#  Revision: 1.1
#
#  Log : ssharath
#  Issue #0278
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900133);
  script_bugtraq_id(31289);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");
  script_name(english:"ProFTPD Long Command Handling Security Vulnerability");
  script_summary(english:"Check for vulnerable version of ProFTPD Project");
  desc["english"] = "
  Overview : The host is running ProFTPD Server, which is prone to cross-site 
  request forgery vulnerability.

  Vulnerability Insight :
  The flaw exists due to the application truncating an overly long FTP command,
  and improperly interpreting the remainder string as a new FTP command.

  Impact : This can be exploited to execute arbitrary FTP commands on another
  user's session privileges.

  Impact Level : Application

  Affected Software/OS :
  ProFTPD Project versions 1.2.x on Linux
  ProFTPD Project versions 1.3.x on Linux
 
  Fix : Fixed is available in the SVN repository,
  http://www.proftpd.org/cvs.html

  *****
  NOTE : Ignore this warning, if above mentioned fix is applied already.
  *****

  References :
  http://secunia.com/advisories/31930/
  http://bugs.proftpd.org/show_bug.cgi?id=3115

  CVSS Score :
    CVSS Base Score     : 5.5 (AV:N/AC:L/Au:SI/C:P/I:P/A:N)
    CVSS Temporal Score : 4.3
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencies("find_service.nes");
  exit(0);
}

include("ftp_func.inc");

port = get_kb_item("Services/ftp");
if(!port){
  port = 21;
}

if(!get_port_state(port)){
  exit(0);
}

banner = get_ftp_banner(port:port);
if("ProFTPD" >!< banner){
  exit(0);
}
 
if(egrep(pattern:"ProFTPD 1\.(2(\..*)?|3(\.0|\.1(rc[0-3])?[^rc])?)[^.0-9]",
         string:banner)){
  security_warning(port);
}
