##############################################################################
#
#  Microsoft iExplorer '&NBSP;' Address Bar URI Spoofing Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/31
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0420
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900170);
  script_bugtraq_id(31960);
  script_cve_id("CVE-2008-4787");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Misc.");
  script_name(english:"Microsoft iExplorer '&NBSP;' Address Bar URI Spoofing Vulnerability");
  script_summary(english:"Check for vulnerable version of Microsoft Internet Explorer");
  desc["english"] = "
  Overview: This host is installed with Microsoft Internet Explorer and is prone
  to URI spoofing vulnerability.

  The flaw is exists due to failure to adequately handle specific combination
  of the non-breaking space character like '&NBSP;'.

  Impact:
  Attacker may leverage this issue to spoof the source URI of a site which leads
  to false sense of trust.

  Impact Level: System

  Affected Software/OS:
  Microsoft Internet Explorer versions 6.0 SP1 and prior

  Fix: No solution/patch is available as on 31st October, 2008.

  References:
  http://web.nvd.nist.gov/view/vuln/detail?execution

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Internet Explorer";
iExpVer = registry_get_sz(key:key , item:"Version");
if(!iExpVer){
  iExpVer = registry_get_sz(key:key, item:"W2kVersion");
  if(!iExpVer){
    exit(0);
  }
}

# Grep for version 6.0 x
if(ereg(pattern:"^6\.0", string:iExpVer)){
  security_warning(0);
}
