##############################################################################
#
#  Windows Internet Printing Service Allow Remote Code Execution Vulnerability (953155)
#
#  Copyright: SecPod
#
#  Date Written: 2008/10/15
#
#  Revision: 1.1
#
#  Log: schandan
#  Issue #0333
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
  script_id(900052);
  script_bugtraq_id(31682);
  script_cve_id("CVE-2008-1446");
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.1 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows : Microsoft Bulletins");
  script_name(english:"Windows Internet Printing Service Allow Remote Code Execution Vulnerability (953155)");
  script_summary(english:"Check for Hotfix and version of Internet Printing Service");
  desc["english"] = "
  MS08-062

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-062.

  Vulnerability Insight:
  The flaw is caused due to an integer overflow error within the IPP
  (Internet Printing Protocol) ISAPI extension for IIS when processing
  specially crafted IPP responses.

  Impact: Successful exploitation result in execution of arbitrary code by
  tricking Web Server into visting to a malicious IPP server via a specially
  crafted HTTP POST request.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K Service Pack 4 and prior.
  Microsoft Windows XP Service Pack 3 and prior.
  Microsoft Windows 2003 Service Pack 2 and prior.

  Fix: Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-062.mspx

  References: http://www.microsoft.com/technet/security/bulletin/ms08-062.mspx

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_dependencies("secpod_reg_enum.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(win2k:5, xp:4, win2003:3) <= 0){
  exit(0);
}

# Check Hotfix Missing 953155 (MS08-062)
if(hotfix_missing(name:"953155") == 0){
  exit(0);
}

sysPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                          item:"Install Path");
if(!sysPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:sysPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:sysPath + "\Win32spl.dll");

sysVer = GetVer(file:file, share:share);
if(!sysVer){
  exit(0);
}

# Windows 2K
if(hotfix_check_sp(win2k:5) > 0)
{
  # Grep for Win32spl.dll version < 5.0.2195.7188
  if(egrep(pattern:"^5\.0\.2195\.([0-6]?[0-9]?[0-9]?[0-9]|7(0[0-9][0-9]|" +
                   "1[0-7][0-9]|18[0-7]))$", string:sysVer)){
    security_warning(0);
  }
  exit(0);
}

# Windows XP
if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Grep for Win32spl.dll < 5.1.2600.3435
    if(egrep(pattern:"^5\.1\.2600\.([0-2]?[0-9]?[0-9]?[0-9]|3([0-3][0-9][0-9]|" +
                     "4([0-2][0-9]|3[0-4])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Grep for Win32spl.dll < 5.1.2600.5664
    if(egrep(pattern:"^5\.1\.2600\.([0-4]?[0-9]?[0-9]?[0-9]|5([0-5][0-9][0-9]|" +
                     "6([0-5][0-9]|6[0-3])))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}

# Windows 2003
if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Grep for Win32spl.dll version < 5.2.3790.3208
    if(egrep(pattern:"^5\.2\.3790\.([0-2]?[0-9]?[0-9]?[0-9]|3([01][0-9][0-9]|" +
                     "20[0-7]))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  else if("Service Pack 2" >< SP)
  {
    # Grep for Win32spl.dll version < 5.2.3790.4371
    if(egrep(pattern:"^5\.2\.3790\.([0-3]?[0-9]?[0-9]?[0-9]|4([0-2][0-9][0-9]|" +
                     "3([0-6][0-9]|70)))$", string:sysVer)){
       security_warning(0);
    }
    exit(0);
  }
  security_warning(0);
}
