##############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mediawiki_mult_xss_vuln.nasl 1074 2009-02-26 18:02:29Z feb $
#
# MediaWiki Multiple XSS Vulnerabilities
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900469);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(33681);
  script_cve_id("CVE-2009-0737");
  script_name(english:"MediaWiki Multiple XSS Vulnerabilities");
  desc["english"] = "

  Overview: This host is running MediaWiki and is prone to Multiple XSS
  Vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are caused as the data supplied by the user via unspecified
  vectors is not adequately sanitised before being passed into the file
  'config/index.php' of MediaWiki.

  Impact:
  Successful exploitation will let the attacker include arbitrary HTML or web
  scripts in the scope of the browser. This may lead to cross site scripting
  attacks and the attacker may gain sensitive information of the remote user
  or of the web application.

  Impact level: Application

  Affected Software/OS:
  MediaWiki version prior to 1.13.4
  MediaWiki version prior to 1.12.4
  MediaWiki version prior to 1.6.12

  Fix:
  Apply the security updates accordingly.
  MediaWiki Version 1.13.4
  MediaWiki Version 1.12.4
  MediaWiki Version 1.6.12

  References:
  http://secunia.com/advisories/33881
  http://www.vupen.com/english/advisories/2009/0368

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 1.9
  Risk factor: Low";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of MediaWiki");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Web application abuses");
  script_require_ports("Services/www", 80);
  script_dependencies("secpod_mediawiki_detect.nasl");
  script_require_keys("MediaWiki/Version");
  exit(0);
}


include("version_func.inc");

wikiPort = get_kb_item("Services/www");
if(!get_port_state(wikiPort)){
  exit(0);
}

mediawiki = get_kb_item("MediaWiki/Version");
if(!mediawiki){
  exit(0);
}

if(mediawiki != NULL)
{
  # Grep for affected MediaWiki Versions
  if(version_in_range(version:mediawiki, test_version:"1.13", test_version2:"1.13.3") ||
     version_in_range(version:mediawiki, test_version:"1.12", test_version2:"1.12.3") ||
     version_in_range(version:mediawiki, test_version:"1.6", test_version2:"1.6.11")){
    security_warning(wikiPort);
    exit(0);
  }
}
