###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_mediawiki_detect.nasl 771 2008-12-17 13:15:29Z dec $
#
# MediaWiki Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright (c) 2008 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900420);
  script_version("$Revision: 1.0 $");
  script_name(english:"MediaWiki script Version Detection");
  desc["english"] = "

  Overview: The script detects the version of MediaWiki on remote host
  and sets the KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Check for MediaWiki script version");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_family(english:"General");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  port = 80;
}

foreach dir (make_list("/wiki", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php/Special:Version"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if("[P|p]owered by" && "MediaWiki" >< rcvRes)
  {
    wikiVer = eregmatch(pattern:"MediaWiki ([0-9.]+)", string:rcvRes);
    if(wikiVer[1] != NULL){
      set_kb_item(name:"MediaWiki/Version", value:wikiVer[1]);
    }
    exit(0);
  }
}
