###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_limesurvey_detect.nasl 2247 2009-05-15 20:37:29Z may $
#
# LimeSurvey Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900352);
  script_version("$Revision: 1.0 $");
  script_name(english:"LimeSurvey Version Detection");
  desc["english"] = "

  Overview: The script detects the installed version of LimeSurvey on remote
  host and saves the result in KB.

  Risk Factor: Informational";

  script_description(english:desc["english"]);
  script_summary(english:"Sets for the version of LimeSurvey in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");

surveyPort = get_http_port(default:80);
if(!surveyPort){
  surveyPort = 80;
}

if(!get_port_state(surveyPort)){
  exit(0);
}

foreach dir (make_list("/limesurvey", "/phpsurveyor", "/survey", "/", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/admin/admin.php"), port:surveyPort);
  rcvRes = http_send_recv(port:surveyPort, data:sndReq);

  # Set KB for the version of LimeSurvey Product
  if("<title>LimeSurvey</title>" >< rcvRes)
  {
    req = http_get(item:string(dir, "/docs/release_notes_and_upgrade" +
                                    "_instructions.txt"),
                               port:surveyPort);
    res = http_send_recv(port:surveyPort, data:req);

    if(res != NULL)
    {
      surveyVer = eregmatch(pattern:"LimeSurvey v([0-9.RCa-z]+)\+?!([^.0-9]|$)",
                            string:res);
      if(surveyVer[1] != NULL)
      {
        set_kb_item(name:"www/" + surveyPort + "/LimeSurvey",
                    value:surveyVer[1] + " under " + dir);
      }
    }
  }

  # Set KB for the version of PHPSurveyor or Surveyor Product
  # Note: PHPSurveyor or Surveyor are the product name of old LimeSurvey
  if("<title>PHPSurveyor</title>" >< rcvRes ||
     "<title>Surveyor</title>" >< rcvRes)
  {
    surveyorVer = eregmatch(pattern:"Ver(sion)? ([0-9.RCa-z]+)([^.0-9]|$)",
                             string:rcvRes);
    if(surveyorVer[2] != NULL)
    {
      set_kb_item(name:"www/" + surveyPort + "/LimeSurvey",
                  value:surveyorVer[2] + " under " + dir);
    }
  }
}
