#############################################################################
#
#  IBM DB2 Server Detection (Windows)
#
#  Copyright: SecPod
#
#  Date Written: 2008/09/12
#
#  Modified by: Sujit Ghosal (sghosal@secpod.com) #1465
#  Date: 5th May 2009
#
#  Revision: 1.2
#
#  Log: veerendragg
#  Issue #0187
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL,
#  and information regarding obtaining source code from the Author.
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the
#  information found in this header with any distribution you make of this
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
 script_id(900218);
 script_copyright(english:"Copyright (C) 2008 SecPod");
 script_version("Revision: 1.2 ");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Service detection");
 script_name(english:"IBM DB2 Server Detection (Windows)");
 script_summary(english:"Set KB for IBM DB2 Server");
 desc["english"] = "
 This script detects the version of IBM DB2 Server and saves the
 results in KB.

 Risk factor : Informational";

 script_description(english:desc["english"]);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  if(registry_get_sz(key:key + item, item:"Publisher") =~ "IBM")
  {
    appName = registry_get_sz(item:"DisplayName", key:key + item);
    if("DB2" >< appName)
    {
      appVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(appVer != NULL)
      {
        set_kb_item(name:"Win/IBM-db2/Ver", value:appVer);
        exit(0);
      }
    }exit(0);
  }
}
