##############################################################################
#
#  Free Directory Script 'API_HOME_DIR' File Inclusion Vulnerability
#
#  Copyright: SecPod
#
#  Date Written: 2008/11/24
#
#  Revision: 1.0
#
#  Log: ssharath
#  Issue #0512
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################

if(description)
{
  script_id(900181);
  script_copyright(english:"Copyright (C) 2008 SecPod");
  script_version("Revision: 1.0 ");
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses : XSS");
  script_name(english:"Free Directory Script 'API_HOME_DIR' File Inclusion Vulnerability");
  script_summary(english:"Check for the vulnerable version of Free Directory Script");
  desc["english"] = "
  Overview : This host is installed with Free Directory Script and is prone to
  File Inclusion Vulnerability.

  Vulnerability Insight:
  The Error occurs when passing an input parameter into the 'API_HOME_DIR' in
  'init.php' file which is not properly verified before being used to include
  files. This can be exploited to include arbitrary files from local or
  external resources.

  Impact:
  Successful exploitation will let the attacker add, modify or delete files 
  from the server and can let the attacker install trojans or backdoors.

  Impact Level: Application

  Affected Software/OS: 
  Free Directory Script version 1.1.1 and prior.

  Workaround: Edit the source code to ensure that input is properly verified.

  Fix: No patch is available as on 24th November, 2008.

  References:
  http://milw0rm.com/exploits/7155
  http://secunia.com/advisories/32745

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

 script_description(english:desc["english"]);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/FreeDirectory", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:port);
  rcvRes = http_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"Free Directory Script", string:rcvRes) && 
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    pattern = "FDS Version (0(\..*)|1\.(0(\..*)?|1(\.[01])?))($|[^.0-9])";
    if(egrep(pattern:pattern, string:rcvRes)){
      security_warning(port);
      exit(0);
    }
  }
}
