###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cups_dns_rebinding_vuln.nasl 1967 2009-04-27 20:59:24Z apr $
#
# CUPS HTTP Host Header DNS Rebinding Attacks
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900349);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0164");
  script_bugtraq_id(34665);
  script_name(english:"CUPS HTTP Host Header DNS Rebinding Attacks");
  desc["english"] = "

  Overview: This host is running CUPS, and is prone to DNS Rebinding Attacks.

  Vulnerability Insight:
  The flaw is cause due to insufficient validation of the HTTP Host header
  in a client request.

  Impact:
  An attacker can use this weakness to carry out certain attacks such as
  DNS rebinding against the vulnerable server.

  Impact Level: Application

  Affected Software/OS:
  CUPS version prior to 1.3.10

  Fix: Upgrade to version 1.3.10 or latest
  http://www.cups.org/software.php

  References:
  http://www.cups.org/str.php?L3118
  http://www.cups.org/articles.php?L582
  http://bugs.gentoo.org/show_bug.cgi?id=263070
  https://bugzilla.redhat.com/show_bug.cgi?id=490597

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score : 4.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of CUPS");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 SecPod");
  script_family(english:"General");
  script_dependencies("secpod_cups_detect.nasl");
  script_require_ports("Services/www", 631);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

cupsPort = get_http_port(default:631);
if(!cupsPort){
  exit(0);
}

cupsVer = get_kb_item("www/"+ cupsPort + "/CUPS");
if(!cupsVer){
  exit(0);
}

if(cupsVer != NULL)
{
  # Check for CUPS version < 1.3.10
  if(version_is_less(version:cupsVer, test_version:"1.3.10")){
    security_warning(cupsPort);
  }
}
