###############################################################################
# OpenVAS Vulnerability Test
# $Id: postgresql_34069.nasl 3194 2009-04-24 18:04:08Z mime $
#
# PostgreSQL Low Cost Function Information Disclosure Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100158);
 script_bugtraq_id(34069);
 script_version ("1.0");

 script_name(english:"PostgreSQL Low Cost Function Information Disclosure Vulnerability");
 desc["english"] = "

 Overview:
  PostgreSQL is prone to an information-disclosure vulnerability.

  Local attackers can exploit this issue to obtain sensitive
  information that may lead to further attacks.

  PostgreSQL 8.3.6 is vulnerable; other versions may also be affected.

 See also:
  http://www.securityfocus.com/bid/34069
  http://www.postgresql.org/

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if PostgreSQL is vulnerable to Information Disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Databases");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("postgresql_detect.nasl");
 script_require_ports("Services/postgresql", 5432);
 exit(0);
}

include("version_func.inc");
include("misc_func.inc");

port = get_kb_item("Services/postgresql");
if(!port)port = 5432;
if(!get_tcp_port_state(port))exit(0);

if(!ver = get_kb_list(string("PostgreSQL/Remote/", port, "/Ver")))exit(0);

if(version_in_range(version:ver, test_version:"8.3", test_version2:"8.3.6") )
{
     security_warning(port:port);
     exit(0);
} 

exit(0); 
