###############################################################################
# OpenVAS Vulnerability Test
# $Id:$
#
# osCommerce unprotected admin directory
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100003);
 script_version ("1.0");

 script_name(english:"osCommerce unprotected admin directory");
 desc["english"] = "

 Overview:
  This host is running osCommerce, a widely installed open source shopping e-commerce solution.
  See http://www.oscommerce.com for more information.

  The store admin directory on your server needs to be password protected using .htaccess.
  Most of the time the server you are hosting your store on has the ability to password protect
  directories through the server administration area so check with your host.

 Solution:
  Limit access to the directory using .htaccess.
  See http://www.oscommerce.info/docs/english/e_post-installation.html for further Information.

 Risk factor : Medium";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if osCommerce admin directory is unprotected");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("oscommerce_detect.nasl");
 script_require_keys("Software/osCommerce");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

dir = get_kb_list("Software/osCommerce/dir"); 

foreach d (dir)
{ 
 url = string(d, "/admin/customers.php");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )exit(0);
 if ( ereg(pattern: "^HTTP/1\.[01] +200", string: buf) &&
      egrep(pattern: 'href=.*http.*?gID=.*&selected_box=.*&osCAdminID=', string: buf)
    ) 
   {    
    security_warning(port:port);
    exit(0);
   }
}

exit(0);
