###############################################################################
# OpenVAS Vulnerability Test
# $Id: nsd_35029.nasl 3460 2009-05-24 09:22:37Z mime $
#
# NSD 'packet.c' Off-By-One Buffer Overflow Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(100209);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(35029);
  script_name(english:"NSD 'packet.c' Off-By-One Buffer Overflow Vulnerability");
  desc["english"] = "

  Overview:
   NSD is prone to an off-by-one buffer-overflow vulnerability
   because the server fails to perform adequate boundary checks on
   user-supplied data.

   Successfully exploiting this issue will allow attackers to
   execute arbitrary code within the context of the affected server.
   Failed exploit attempts will result in a denial-of-service
   condition.

   Versions prior to NSD 3.2.2 are vulnerable. 

  Solution:
   The vendor has released fixes. Please see http://www.nlnetlabs.nl/projects/nsd/
   for more information.

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of NSD");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Michael Meyer");
  script_family(english:"General");
  script_dependencies("nsd_version.nasl");
  script_require_keys("nsd/version");
  exit(0);
}


include("version_func.inc");

udpPort = 53;
if(!get_udp_port_state(udpPort)){
  exit(0);
}

bindVer = get_kb_item("nsd/version");
if(!bindVer){
  exit(0);
}

  if(version_is_less(version:bindVer, test_version:"3.2.2") ) {
    security_hole(port:udpPort, proto:"udp");
  }
