###############################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  based on work from
# (C) Tenable Network Security
#
# See the Nessus Scripts License for details
#
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com> 
#
# This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(14181);
  script_bugtraq_id(10796, 10832);
  script_cve_id("CVE-2004-0763", "CVE-2004-0764");
  script_version("$Revision: 2750 $");
  script_name(english:"Mozilla/Firefox user interface spoofing");
  desc["english"] = "
  The remote host is using Mozilla and/or Firefox, an alternative web browser.
  This web browser supports the XUL (XML User Interface Language), a language
  designed to manipulate the user interface of the browser itself.

  Since XUL gives the full control of the browser GUI to the visited websites,
  an attacker may use it to spoof a third party website and therefore pretend
  that the URL and Certificates of the website are legitimate.

  In addition to this, the remote version of this browser is vulnerable to a
  flaw which may allow a malicious web site to spoof security properties
  such as SSL certificates and URIs.

  See also : http://www.nd.edu/~jsmith30/xul/test/spoof.html

  Solution : None at this time

  Risk factor : Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Determines the version of Mozilla/Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"Windows");
  script_dependencies("gb_firefox_detect_win.nasl", "gb_thunderbird_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver", "Thunderbird/Win/Ver");
  exit(0);

}

include("version_func.inc");

mozVer = get_kb_item("Firefox/Win/Ver");
if(mozVer)
{
  # check firefox version < 1.7
  if(version_is_less(version:MozVer ,test_version:"1.7"))
  {
    security_warning(0);
    exit(0);
  }
}

tunBirdVer = get_kb_item("Thunderbird/Win/Ver");
if(!tunBirdVer){
  exit(0);
}

# check for thunderbird version < 0.7
if(version_is_less(version:tunBirdVer ,test_version:"0.7")){
  security_warning(0);
}
