###############################################################################
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
#  based on work from
#  (C) Tenable Network Security
#
#  Ref: Max <spamhole@gmx.at>
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com
#
#  This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(15432);
  script_bugtraq_id(11166);
  script_cve_id("CVE-2004-0906");
  script_version("$Revision: 2750 $");
  script_name(english:"Mozilla/Firefox default installation file permission flaw");
  desc["english"] = "
  The remote host is using Mozilla and/or Firefox, an alternative web browser.
  The remote version of this software is prone to an improper file permission
  setting.

  This flaw only exists if the browser is installed by the Mozilla Foundation
  package management, thus this alert might be a false positive.

  A local attacker could overwrite arbitrary files or execute arbitrary code in
  the context of the user running the browser.

  Solution: Update to the latest version of the software

  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Determines the version of Mozilla/Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2004 David Maciejak");
  script_family(english:"Windows");
  script_dependencies("gb_firefox_detect_win.nasl", "gb_thunderbird_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver", "Thunderbird/Win/Ver");
  exit(0);
}


include("version_func.inc");

mozVer = get_kb_item("Firefox/Win/Ver");
if(mozVer)
{
  # check firefox version < 1.7.3
  if(version_is_less(version:mozVer ,test_version:"1.7.3"))
  {
    security_warning(0);
    exit(0);
  }
}

tunBirdVer = get_kb_item("Thunderbird/Win/Ver");
if(!tunBirdVer){
  exit(0);
}

# check thunderbird version < 0.8
if(version_is_less(version:tunBirdVer,test_version:"0.8")){
  security_warning(0);
}
