# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:103 (udev)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63916);
 script_cve_id("CVE-2009-1185", "CVE-2009-1186");
 script_version ("$");
 name["english"] = "Mandrake Security Advisory MDVSA-2009:103 (udev)";
 script_name(english:name["english"]);

 desc["english"] = "
The remote host is missing an update to udev
announced via advisory MDVSA-2009:103.

Security vulnerabilities have been identified and fixed in udev.

udev before 1.4.1 does not verify whether a NETLINK message originates
from kernel space, which allows local users to gain privileges by
sending a NETLINK message from user space (CVE-2009-1185).

Buffer overflow in the util_path_encode function in
udev/lib/libudev-util.c in udev before 1.4.1 allows local users to
cause a denial of service (service outage) via vectors that trigger
a call with crafted arguments (CVE-2009-1186).

The updated packages have been patched to prevent this.

Affected: 2008.1, 2009.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:103

Risk factor : High";

 script_description(english:desc["english"]);

 summary["english"] = "Mandrake Security Advisory MDVSA-2009:103 (udev)";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family["english"] = "Mandrake Local Security Checks";
 script_family(english:family["english"]);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libvolume_id0", rpm:"libvolume_id0~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id0-devel", rpm:"libvolume_id0-devel~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev-doc", rpm:"udev-doc~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev-tools", rpm:"udev-tools~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64volume_id0", rpm:"lib64volume_id0~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64volume_id0-devel", rpm:"lib64volume_id0-devel~118~6.3mnb1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libudev0", rpm:"libudev0~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libudev0-devel", rpm:"libudev0-devel~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id1", rpm:"libvolume_id1~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvolume_id1-devel", rpm:"libvolume_id1-devel~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev", rpm:"udev~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"udev-doc", rpm:"udev-doc~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64udev0", rpm:"lib64udev0~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64udev0-devel", rpm:"lib64udev0-devel~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64volume_id1", rpm:"lib64volume_id1~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64volume_id1-devel", rpm:"lib64volume_id1-devel~128~2.2mnb2", rls:"MNDK_2009.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
