###############################################################################
# OpenVAS Vulnerability Test
# $Id: ldap_detect.nasl 2932 2009-03-27 11:39:47Z mime $
#
# Detection of LDAP
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100082);
 script_version ("1.0");

 desc["english"] = "

  A LDAP Server is running at this host.

  The Lightweight Directory Access Protocol, or LDAP is an application
  protocol for querying and modifying directory services running over
  TCP/IP.

 Risk factor : None";

 script_name(english:"LDAP Detection");  

 script_description(english:desc["english"]);
 script_summary(english:"Check for LDAP");
 script_category(ACT_GATHER_INFO);
 script_family(english:"Service detection");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes");
 script_require_ports("Services/ldap", 389);
 exit(0);
}

include("misc_func.inc");

port = get_kb_item("Services/ldap");
if(!port)port = 389;
if(!get_port_state(port))exit(0);

soc = open_sock_tcp(port);
if(!soc)exit(0);

req = raw_string(0x30,0x84,0x00,0x00,0x00,0x59,0x02,0x01,0x05,0x63,0x84,0x00,
		 0x00,0x00,0x50,0x04,0x13,0x64,0x63,0x3d,0x6f,0x70,0x65,0x6e,
		 0x76,0x61,0x73,0x64,0x63,0x2c,0x64,0x63,0x3d,0x6e,0x65,0x74,
		 0x0a,0x01,0x02,0x0a,0x01,0x00,0x02,0x01,0x00,0x02,0x01,0x00,
		 0x01,0x01,0x00,0xa3,0x84,0x00,0x00,0x00,0x13,0x04,0x0b,0x6f,
		 0x62,0x6a,0x65,0x63,0x74,0x43,0x6c,0x61,0x73,0x73,0x04,0x04,
		 0x75,0x73,0x65,0x72,0x30,0x84,0x00,0x00,0x00,0x0d,0x04,0x0b,
		 0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x4e,0x61,0x6d,0x65); # ldapsearch "dc=openvasdc,dc=net"

send(socket:soc, data:req);
buf = recv(socket:soc, length:1);
if( buf == NULL ) exit(0);
close(soc);

if(strlen(buf) == 1) {
  response = hexstr(buf);

  if(response =~ "^30$" ) {
    register_service(port:port, ipproto:"tcp", proto:"ldap");
    security_note(port:port);
    exit(0);
   }
}

exit(0);
