###############################################################################
# OpenVAS Vulnerability Test
# $Id: ghostScripter_amazon_shop_multiple_vulnerabilities.nasl 100 2009-03-08 09:29:53Z mime $
#
# GhostScripter Amazon Shop Multiple Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Michael Meyer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100024);
 script_bugtraq_id(33994);
 script_version ("1.0");

 script_name(english:"GhostScripter Amazon Shop Multiple Vulnerabilities");
 desc["english"] = "

 Overview:
  Amazon Shop is prone to multiple vulnerabilities, including a
  cross-site scripting issue, a directory-traversal issue, and
  multiple remote file-include issues, because it fails to
  sufficiently sanitize user-supplied data.

  An attacker can exploit these issues to run malicious PHP code in
  the context of the webserver process, run script code in an
  unsuspecting user's browser, steal cookie-based authentication
  credentials, or obtain sensitive information; other attacks are also
  possible. 

 Risk factor : High";

 script_description(english:desc["english"]);
 script_summary(english:"Determine if GhostScripter Amazon Shop is prone to multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2009 Michael Meyer");
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port)) exit(0);

dir = make_list("/amazon", cgi_dirs());

foreach d (dir)
{ 
 url = string(d, "/search.php?query=1<script>alert(document.cookie);</script>&mode=all");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
 if( buf == NULL )continue;
 
 if (
     ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 .*", string:buf) &&
     egrep(pattern:"<script>alert\(document\.cookie\);</script>", string: buf)
    )
     
 	{    
       	  security_hole(port:port);
          exit(0);
        }
}

exit(0);
