###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wireshark_smtp_dos_vuln_win.nasl 565 2008-12-03 10:31:24Z dec $
#
# Wireshark SMTP Processing Denial of Service Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800074);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5285");
  script_bugtraq_id(32422);
  script_name(english:"Wireshark SMTP Processing Denial of Service Vulnerability (Win)");
  desc["english"] = "

  Overview: The Remote host is installed with Wireshark and is prone to
  denial of service vulnerability.

  Vulnerability Insight:
  The flaw is due to an error in the SMTP dissector while processing
  large SMTP packets.

  Impact:
  Successful attacks may cause the application to crash via specially
  crafted packets.

  Impact Level: Application

  Affected Software/OS:
  Wireshark version 1.0.4 and prior on Windows.

  Fix: Upgrade to Wireshark 1.0.5
  http://www.wireshark.org/download.html

  References:
  http://www.vupen.com/english/advisories/2008/3231

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Wireshark");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_wireshark_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

sharkVer = get_kb_item("Wireshark/Win/Ver");
if(!sharkVer){
  exit(0);
}

if(version_is_less_equal(version:sharkVer, test_version:"1.0.4")){
  security_warning(0);
}
