###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for nagios2 vulnerabilities USN-698-3
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840311);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "698-3");
  script_cve_id("CVE-2008-5027", "CVE-2008-5028");
  script_name(english: "Ubuntu Update for nagios2 vulnerabilities USN-698-3");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that Nagios was vulnerable to a Cross-site request forgery
  (CSRF) vulnerability. If an authenticated nagios user were tricked into
  clicking a link on a specially crafted web page, an attacker could trigger
  commands to be processed by Nagios and execute arbitrary programs. This
  update alters Nagios behaviour by disabling submission of CMD_CHANGE commands.
  (CVE-2008-5028)
  
  It was discovered that Nagios did not properly parse commands submitted using
  the web interface. An authenticated user could use a custom form or a browser
  addon to bypass security restrictions and submit unauthorized commands.
  (CVE-2008-5027)

  Affected Software/OS:
  nagios2 vulnerabilities on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/000815.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of nagios2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"nagios2-dbg", ver:"2.11-1ubuntu1.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios2", ver:"2.11-1ubuntu1.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios2-common", ver:"2.11-1ubuntu1.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nagios2-doc", ver:"2.11-1ubuntu1.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}