###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for mysql-dfsg-5.0 vulnerabilities USN-671-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840292);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "671-1");
  script_cve_id("CVE-2008-2079", "CVE-2008-3963", "CVE-2008-4097", "CVE-2008-4098");
  script_name(english: "Ubuntu Update for mysql-dfsg-5.0 vulnerabilities USN-671-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that MySQL could be made to overwrite existing table
  files in the data directory. An authenticated user could use the
  DATA DIRECTORY and INDEX DIRECTORY options to possibly bypass privilege
  checks. This update alters table creation behaviour by disallowing the
  use of the MySQL data directory in DATA DIRECTORY and INDEX DIRECTORY
  options. (CVE-2008-2079, CVE-2008-4097 and CVE-2008-4098)
  
  It was discovered that MySQL did not handle empty bit-string literals
  properly. An attacker could exploit this problem and cause the MySQL
  server to crash, leading to a denial of service. (CVE-2008-3963)

  Affected Software/OS:
  mysql-dfsg-5.0 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000778.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of mysql-dfsg-5.0 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.22-0ubuntu6.06.11", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.51a-3ubuntu5.4", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0_5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0_5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.45-1ubuntu3.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}