###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dnsmasq vulnerability USN-627-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840230);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "627-1");
  script_cve_id("CVE-2008-1447");
  script_name(english: "Ubuntu Update for dnsmasq vulnerability USN-627-1");
  desc["english"] = "

  Vulnerability Insight:

  Dan Kaminsky discovered weaknesses in the DNS protocol as implemented
  by Dnsmasq. A remote attacker could exploit this to spoof DNS entries
  and poison DNS caches. Among other things, this could lead to
  misdirected email and web traffic.

  Affected Software/OS:
  dnsmasq vulnerability on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-July/000730.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dnsmasq vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"dnsmasq-base", ver:"2.41-2ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dnsmasq", ver:"2.41-2ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}