###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux vulnerabilities USN-614-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840267);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "614-1");
  script_cve_id("CVE-2007-6694", "CVE-2008-1375", "CVE-2008-1669", "CVE-2008-1675");
  script_name(english: "Ubuntu Update for linux vulnerabilities USN-614-1");
  desc["english"] = "

  Vulnerability Insight:

  It was discovered that PowerPC kernels did not correctly handle reporting
  certain system details.  By requesting a specific set of information,
  a local attacker could cause a system crash resulting in a denial
  of service. (CVE-2007-6694)
  
  A race condition was discovered between dnotify fcntl() and close() in
  the kernel.  If a local attacker performed malicious dnotify requests,
  they could cause memory consumption leading to a denial of service,
  or possibly send arbitrary signals to any process. (CVE-2008-1375)
  
  On SMP systems, a race condition existed in fcntl().  Local attackers
  could perform malicious locks, causing system crashes and leading to
  a denial of service. (CVE-2008-1669)
  
  The tehuti network driver did not correctly handle certain IO functions.
  A local attacker could perform malicious requests to the driver,
  potentially accessing kernel memory, leading to privilege escalation
  or access to private system information. (CVE-2008-1675)

  Affected Software/OS:
  linux vulnerabilities on Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/000714.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of linux vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-386_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-generic_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-server_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-virtual_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-386_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-generic_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-server_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-virtual_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-386_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-generic_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-server_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-virtual_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-386_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-generic_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-server_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-virtual_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-386_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-generic_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-openvz_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-rt_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-server_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-virtual_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18-xen_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-386_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-generic_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-server_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-virtual_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-18-386_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-18-generic_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-18-server_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug", ver:"2.6.24-18-virtual_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-kernel-source_8-3+2.6.24.13", ver:"18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-openvz_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-rt_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-xen_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy-dev", ver:"71.86.04+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-legacy", ver:"71.86.04+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-kernel-source", ver:"96.43.05+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-legacy-kernel-source", ver:"71.86.04+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-firmware", ver:"2.6.24-18_3.11+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"avm-fritz-kernel-source", ver:"3.11+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-amdcccle", ver:"2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"fglrx-control_8-3+2.6.24.13", ver:"18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-386_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-generic_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules", ver:"2.6.24-18-server_2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-dev", ver:"96.43.05+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-new-dev", ver:"169.12+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx-new", ver:"169.12+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-glx", ver:"96.43.05+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"nvidia-new-kernel-source", ver:"169.12+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx-dev", ver:"7.1.0-8-3+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xorg-driver-fglrx", ver:"7.1.0-8-3+2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-openvz_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-rt_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-backports-modules", ver:"2.6.24-18-xen_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-openvz_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-rt_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lbm", ver:"2.6.24-18-xen_2.6.24-18.16", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-openvz_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-rt_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-lum", ver:"2.6.24-18-xen_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-openvz_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-rt_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ubuntu-modules", ver:"2.6.24-18-xen_2.6.24-18.26", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-openvz_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-rt_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.24-18-xen_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.24_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.24-18_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.24_2.6.24-18.32", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-restricted-modules-common", ver:"2.6.24.13-18.41", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}