###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for e2fsprogs vulnerability USN-555-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840024);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "555-1");
  script_cve_id("CVE-2007-5497");
  script_name(english: "Ubuntu Update for e2fsprogs vulnerability USN-555-1");
  desc["english"] = "

  Vulnerability Insight:

  Rafal Wojtczuk discovered multiple integer overflows in e2fsprogs.  If a
  user or automated system were tricked into fscking a malicious ext2/ext3
  filesystem, a remote attacker could execute arbitrary code with the user's
  privileges.

  Affected Software/OS:
  e2fsprogs vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-December/000639.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of e2fsprogs vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"comerr-dev", ver:"2.1-1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs-dev", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsprogs", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid-dev", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid1", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcomerr2", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libss2", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuuid1", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ss-dev", ver:"2.0-1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uuid-dev", ver:"1.2-1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsck-static", ver:"1.39+1.40-WIP-2006.11.14+dfsg-2ubuntu1.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"comerr-dev", ver:"2.1-1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs-dev", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsprogs", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid-dev", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid1", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcomerr2", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libss2", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuuid1", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ss-dev", ver:"2.0-1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uuid-dev", ver:"1.2-1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsck-static", ver:"1.38-2ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"comerr-dev", ver:"2.1-1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs-dev", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsprogs", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid-dev", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid1", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcomerr2", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libss2", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuuid1", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ss-dev", ver:"2.0-1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uuid-dev", ver:"1.2-1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsck-static", ver:"1.39-1ubuntu0.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"comerr-dev", ver:"2.1-1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs-dev", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fslibs", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsprogs", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid-dev", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libblkid1", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libcomerr2", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libss2", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuuid1", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ss-dev", ver:"2.0-1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uuid-dev", ver:"1.2-1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"e2fsck-static", ver:"1.40.2-1ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}