###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openoffice.org/-amd64, openoffice.org2/-amd64 vulnerability USN-406-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840133);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "406-1");
  script_cve_id("CVE-2006-5870");
  script_name(english: "Ubuntu Update for openoffice.org/-amd64, openoffice.org2/-amd64 vulnerability USN-406-1");
  desc["english"] = "

  Vulnerability Insight:

  An integer overflow was discovered in OpenOffice.org's handling of WMF
  files.  If a user were tricked into opening a specially crafted WMF
  file, an attacker could execute arbitrary code with user privileges.

  Affected Software/OS:
  openoffice.org/-amd64, openoffice.org2/-amd64 vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000465.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openoffice.org/-amd64, openoffice.org2/-amd64 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-so52", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-evolution", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk-gnome", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-en-us", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-base", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-calc", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-draw", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-gnome", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-impress", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-kde", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-math", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-writer", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.0.2-2ubuntu12.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-base", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-calc", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-core", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-dev", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-draw", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-evolution", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-filter-so52", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-gnome", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-impress", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-kde", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-math", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-officebean", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-writer", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-common", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-dev-doc", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-java-common", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org2-l10n-en-us", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"1.9.129-0.1ubuntu4.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}