###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2008:052
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850045);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-052");
  script_cve_id("CVE-2007-6716", "CVE-2008-1673", "CVE-2008-2812", "CVE-2008-2826", "CVE-2008-3272", "CVE-2008-3276", "CVE-2008-3525", "CVE-2008-3528", "CVE-2008-4576");
  script_name(english: "SuSE Update for kernel SUSE-SA:2008:052");
  desc["english"] = "

  Vulnerability Insight:

  The openSUSE 10.3 kernel was update to 2.6.22.19. This includes bugs
  and security fixes.

  CVE-2008-4576: Fixed a crash in SCTP INIT-ACK, on mismatch between
  SCTP AUTH availability. This might be exploited remotely for a denial
  of service (crash) attack.

  CVE-2008-3528: The ext[234] filesystem code fails to properly handle
  corrupted data structures. With a mounted filesystem image or partition
  that have corrupted dir-&gt;i_size and dir-&gt;i_blocks, a user performing
  either a read or write operation on the mounted image or partition
  can lead to a possible denial of service by spamming the logfile.

  CVE-2007-6716: fs/direct-io.c in the dio subsystem in the Linux kernel
  did not properly zero out the dio struct, which allows local users
  to cause a denial of service (OOPS), as demonstrated by a certain
  fio test.

  CVE-2008-3525: Added missing capability checks in sbni_ioctl().

  CVE-2008-3272: Fixed range checking in the snd_seq OSS ioctl, which
  could be used to leak information from the kernel.

  CVE-2008-3276: An integer overflow flaw was found in the Linux kernel
  dccp_setsockopt_change() function. An attacker may leverage this
  vulnerability to trigger a kernel panic on a victim's machine remotely.

  CVE-2008-1673: Added range checking in ASN.1 handling for the CIFS
  and SNMP NAT netfilter modules.

  CVE-2008-2826: A integer overflow in SCTP was fixed, which might have
  been used by remote attackers to crash the machine or potentially
  execute code.

  CVE-2008-2812: Various NULL ptr checks have been added to tty op
  functions, which might have been used by local attackers to execute
  code. We think that this affects only devices openable by root,
  so the impact is limited.

  Impact:
  remote denial of service

  Affected Software/OS:
  kernel on openSUSE 10.3

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_52_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.22.19~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}