###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2008:047
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850008);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-047");
  script_cve_id("CVE-2007-6716", "CVE-2008-0598", "CVE-2008-1673", "CVE-2008-2812", "CVE-2008-3272", "CVE-2008-3525");
  script_name(english: "SuSE Update for kernel SUSE-SA:2008:047");
  desc["english"] = "

  Vulnerability Insight:

  The Linux kernel in the SUSE Linux Enterprise Server 9
  Service Pack 4 was released to fix various bugs and also some security
  problems:

  CVE-2007-6716: Zero the struct dio with kzalloc instead of doing
  it member-wise, this could have leaked information from the kernel.

  CVE-2008-3525: Added missing capability checks in sbni_ioctl().

  CVE-2008-0598: On AMD64 some string operations could leak kernel
  information into user space.

  CVE-2008-1673: Added range checking in ASN.1 handling for the CIFS and
  SNMP NAT netfilter modules.

  CVE-2008-3272: Fixed range checking in the snd_seq OSS ioctl, which
  could be used to leak information from the kernel.

  CVE-2008-2812: Various NULL ptr checks have been added to tty op
  functions, which might have been used by local attackers to execute
  code. We think that this affects only devices openable by root, so the
  impact is limited.

  More details are available in the package changelog.

  Impact:
  remote denial of service

  Affected Software/OS:
  kernel on SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_47_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.28", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.314", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.28", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.314", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}