###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for openwsman SUSE-SA:2008:041
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850013);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-041");
  script_cve_id("CVE-2008-2233", "CVE-2008-2234", "CVE-2008-3337", "CVE-2008-1447", "CVE-2007-6389", "CVE-2008-2079", "CVE-2006-7232", "CVE-2008-1801", "CVE-2008-1802", "CVE-2008-1803");
  script_name(english: "SuSE Update for openwsman SUSE-SA:2008:041");
  desc["english"] = "

  Vulnerability Insight:

  The openwsman project provides an implementation of the Web Service
  Management specification.
  The SuSE Security-Team has found two critical issues in the code:
  - two remote buffer overflows while decoding the HTTP basic authentication
  header CVE-2008-2234
  - a possible SSL session replay attack affecting the client (depending on
  the configuration) CVE-2008-2233
  Both issues were fixed.

  Impact:
  remote code execution

  Affected Software/OS:
  openwsman on openSUSE 10.3, openSUSE 11.0

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_41_openwsman.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of openwsman");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"openwsman", rpm:"openwsman~1.2.0~14.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-client", rpm:"openwsman-client~1.2.0~14.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-devel", rpm:"openwsman-devel~1.2.0~14.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-server", rpm:"openwsman-server~1.2.0~14.4", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE11.0")
{

  if(isrpmvuln(pkg:"openwsman-debuginfo", rpm:"openwsman-debuginfo~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-debugsource", rpm:"openwsman-debugsource~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwsman-devel", rpm:"libwsman-devel~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libwsman1", rpm:"libwsman1~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-client", rpm:"openwsman-client~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-python", rpm:"openwsman-python~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-ruby", rpm:"openwsman-ruby~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openwsman-server", rpm:"openwsman-server~2.0.0~3.3", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}