###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for bind SUSE-SA:2008:033
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850041);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-033");
  script_cve_id("CVE-2008-1447");
  script_name(english: "SuSE Update for bind SUSE-SA:2008:033");
  desc["english"] = "

  Vulnerability Insight:

  The bind daemon is responsible for resolving hostnames in IP addresses and
  vice versa.
  The new version of bind uses a random transaction-ID (TRXID) and a random
  UDP source-port for DNS queries to address DNS cache poisoning attacks
  possible because of the &quot;birthday paradox&quot; and an attack discovered by Dan
  Kaminsky. Unfortunately we do not have details about Kaminsky's attack and
  have to trust the statement that a random UDP source-port is sufficient to
  stop it.
  DNS servers that do not support recursive queries or do not use a cache
  (authoritative only servers) are not vulnerable too.

  Update packages of bind9 for SLES8 will be available soon.

  The glibc stub resolver is known to be vulnerable too and we will publish
  updates as soon as possible.

  Note, a local attacker can always sniff DNS queries and generate spoofed
  responses easily.

  If you use the UDP source-port number of the DNS server in your firewall
  configuration, for example to let DNS queries through your packetfilter,
  then you have to take steps to adapt your filter rules to the new behavior
  of the DNS server.

  Impact:
  DNS cache poisoning

  Affected Software/OS:
  bind on openSUSE 10.2, openSUSE 10.3, openSUSE 11.0, SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9, SUSE Linux Enterprise Desktop 10 SP1, SLE SDK 10 SP1, SLE SDK 10 SP2, SUSE Linux Enterprise Server 10 SP1, SUSE Linux Enterprise Desktop 10 SP2, SUSE Linux Enterprise Server 10 SP2

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_33_bind.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of bind");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.4.1.P1~12.5", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.5P1~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"SLESDK10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~4.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~4.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~4.8", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "OES")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~4.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~4.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~4.8", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~4.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~4.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~4.8", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP2")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"LES10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "LES10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"LES10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~4.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~4.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~4.8", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDK10SP2")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"SLESDK10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP1")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"SLESDk10SP1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE11.0")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.4.2~39.2", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLESDk10SP2")
{

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.20.5", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind", rpm:"bind~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-chrootenv", rpm:"bind-chrootenv~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-doc", rpm:"bind-doc~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs-32bit", rpm:"bind-libs-32bit~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.3.4~1.24", rls:"SLESDk10SP2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}