###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for opera SUSE-SA:2008:029
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850015);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-029");
  script_cve_id("CVE-2008-2714", "CVE-2008-2715", "CVE-2008-2716");
  script_name(english: "SuSE Update for opera SUSE-SA:2008:029");
  desc["english"] = "

  Vulnerability Insight:

  The Opera web browser was brought to security update level 9.50

  Following security problems were fixed:

  CVE-2008-2714: Opera before 9.26 allows remote attackers to
  misrepresent web page addresses using &quot;certain characters&quot; that
  &quot;cause the page address text to be misplaced.&quot;

  CVE-2008-2715: Unspecified vulnerability in Opera before 9.5 allows
  remote attackers to read cross-domain images via HTML CANVAS elements
  that use the images as patterns.

  CVE-2008-2716: Unspecified vulnerability in Opera before 9.5 allows
  remote attackers to spoof the contents of trusted frames on the same
  parent page by modifying the location, which can facilitate phishing
  attacks.

  Opera 9.50 also contains lots of new features and other bugfixes,
  see the Changelog at:

  http://www.opera.com/docs/changelogs/linux/950/

  Impact:
  web page spoofing, address misrepresenting

  Affected Software/OS:
  opera on openSUSE 10.2, openSUSE 10.3, openSUSE 11.0

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_29_opera.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of opera");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.50~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.50~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE11.0")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.50~0.1", rls:"openSUSE11.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}