###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for kernel SUSE-SA:2008:017
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850010);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-017");
  script_cve_id("CVE-2007-3848", "CVE-2007-4308", "CVE-2007-5904", "CVE-2007-6151", "CVE-2008-0007");
  script_name(english: "SuSE Update for kernel SUSE-SA:2008:017");
  desc["english"] = "

  Vulnerability Insight:

  The Linux kernel was updated for SUSE Linux Enterprise Server 9 SP4,
  Novell Linux Desktop 9, and Open Enterprise Server and fixes the
  following security problems:

  - Memory overrun vulnerability in ISDN code CVE-2007-6151
  - Insufficient range checks of certain fault handlers CVE-2008-0007
  - Reset current-&gt;pdeath_signal on SUID binary execution CVE-2007-3848
  - aacraid: Fix range checks CVE-2007-4308.
  - fixed a remote buffer overflow in CIFS CVE-2007-5904

  Further improvements include:
  - Several kernel crashes addressed.
  - Improvements to running as a VMWare guest.
  - Update of OCFS2 to 1.2.8-2.
  - New code drop for the s390 architecture.

  For details and a complete list of changes, please refer to the
  package changelog.

  Impact:
  remote denial of service

  Affected Software/OS:
  kernel on SUSE SLES 9, Novell Linux Desktop 9, Open Enterprise Server, Novell Linux POS 9

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_17_kernel.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "OES")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.26", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.311", rls:"OES"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SLES9")
{

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.26", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.311", rls:"SLES9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLDk9")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.26", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.311", rls:"NLDk9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "NLPOS9")
{

  if(isrpmvuln(pkg:"kernel-bigsmp", rpm:"kernel-bigsmp~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-debug", rpm:"kernel-debug~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-default", rpm:"kernel-default~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-smp", rpm:"kernel-smp~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-syms", rpm:"kernel-syms~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-um", rpm:"kernel-um~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xen", rpm:"kernel-xen~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-xenpae", rpm:"kernel-xenpae~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-install-initrd", rpm:"um-host-install-initrd~1.0~48.26", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"um-host-kernel", rpm:"um-host-kernel~2.6.5~7.311", rls:"NLPOS9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}