###############################################################################
# OpenVAS Vulnerability Test
#
# SuSE Update for opera SUSE-SA:2008:011
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(850038);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUSE-SA", value: "2008-011");
  script_cve_id("CVE-2008-1080", "CVE-2008-1081", "CVE-2008-1082");
  script_name(english: "SuSE Update for opera SUSE-SA:2008:011");
  desc["english"] = "

  Vulnerability Insight:

  This is a version update for Opera to version 9.26 to fix:
  - CVE-2008-1080: Fixed an issue where simulated text inputs could
  trick users into uploading arbitrary files, as reported by Mozilla.
  - CVE-2008-1081: Image properties can no longer be used to execute
  scripts, as reported by Max Leonov.
  - CVE-2008-1082: Fixed an issue where the representation of DOM
  attribute values could allow cross site scripting, as reported
  by Arnaud.lb.

  For more information read http://www.opera.com/docs/changelogs/linux/926/

  Impact:
  remote code execution

  Affected Software/OS:
  opera on SUSE LINUX 10.1, openSUSE 10.2, openSUSE 10.3

  Fix: Please Install the Updated Packages.

  References:
  http://www.novell.com/linux/security/advisories/2008_11_opera.html

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of opera");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"SuSE Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "openSUSE10.3")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.26~0.1", rls:"openSUSE10.3"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "openSUSE10.2")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.26~0.1", rls:"openSUSE10.2"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "SL10.1")
{

  if(isrpmvuln(pkg:"opera", rpm:"opera~9.26~0.1", rls:"SL10.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}