###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sphider_query_param_xss_vuln.nasl 530 2008-11-25 18:04:24Z nov $
#
# Sphider query Parameter Cross-Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800308);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5211");
  script_bugtraq_id(29074);
  script_name(english:"Sphider query Parameter Cross-Site Scripting Vulnerability");
  desc["english"] = "

  Overview: This host is running Sphider and is prone to cross-site scripting
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to input passed into the query parameter in search.php
  when suggestion feature is enabled is not properly sanitized before being
  returned to a user.

  Impact:
  Successful attack could lead to execution of arbitrary HTML or scripting code
  in the security context of an affected web page, which allows an attacker to
  steal cookie-based authentication credentials or access and modify data.

  Affected Software/OS:
  Sphider Version 1.3.4 and prior on all running platform.

  Fix: No solution/patch is available as on 28th November, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.sphider.eu/

  References:
  http://xforce.iss.net/xforce/xfdb/42240
  http://users.own-hero.net/~decoder/advisories/sphider134-xss.txt

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 2.3
  Risk factor: Low";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of Sphider");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"CGI abuses : XSS");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/sphider", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/changelog"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq, bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"Sphider .* search engine in PHP", string:rcvRes))
  {
    sphiderVer = eregmatch(pattern:"Sphider ([0-9.]+)", string:rcvRes);
    if(sphiderVer[1] != NULL)
    {
      # Grep for Sphider Version <= 1.3.4
      if(version_is_less_equal(version:sphiderVer[1], test_version:"1.3.4")){
        security_warning(port);
        exit(0);
      }
    }
  }
}
