###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_mult_vuln_july08_lin.nasl 302 2008-10-03 21:03:20Z oct $
#
# Mozilla Seamonkey Multiple Vulnerability July-08 (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800022);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-2798", "CVE-2008-2799", "CVE-2008-2800", "CVE-2008-2801",
                "CVE-2008-2802", "CVE-2008-2803", "CVE-2008-2805", "CVE-2008-2806",
                "CVE-2008-2807", "CVE-2008-2808", "CVE-2008-2809", "CVE-2008-2810",
                "CVE-2008-2811");
  script_bugtraq_id(30038);
  script_xref(name:"CB-A", value:"08-0109");
  script_name(english:"Mozilla Seamonkey Multiple Vulnerability July-08 (Linux)");
  desc["english"] = "

  Overview : The host is installed with Mozilla Seamonkey, that is prone
  to multiple vulnerabilities.

  Vulnerability Insight:
  Issues are due to,
  - multiple errors in the layout and JavaScript engines that can corrupt
    memory.
  - error while handling unprivileged XUL documents that can be exploited
    to load chrome scripts from a fastload file via <script> elements.
  - error in mozIJSSubScriptLoader.LoadScript function can bypass
    XPCNativeWrappers.
  - error in block re-flow process, which can potentially lead to crash.
  - error in processing file URLs contained within local directory listings.
  - errors in the implementation of the Javascript same origin policy
  - errors in the verification of signed JAR files.
  - improper implementation of file upload forms result in uploading specially
    crafted DOM Range and originalTarget elements.
  - error in Java LiveConnect implementation.
  - error in processing of Alt Names provided by peer.
  - error in processing of windows URL shortcuts.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  spoofing attacks, sensitive information disclosure, and JavaScript code
  can execute with the privileges of JAR's signer.

  Impact Level: System

  Affected Software/OS:
  Seamonkey version prior to 1.1.10 on Linux.

  Fix: Upgrade to Seamonkey version 1.1.10 or later
  http://www.seamonkey-project.org/releases/

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-21.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-22.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-23.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-24.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-25.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-27.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-28.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-29.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-30.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-31.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-32.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-33.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("gb_seamonkey_detect_lin.nasl");
  exit(0);
}


# Grep for seamonkey version < 1.1.10
if(egrep(pattern:"^(0\..*|1\.0(\..*)?|1\.1(\.0?[0-9])?)$",
         string:get_kb_item("Seamonkey/Linux/Ver"))){
  security_hole(0);
}
