###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_quagga_dos_vuln.nasl 2181 2009-01-20 18:45:29Z may $
#
# Quagga Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800710);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(34817);
  script_cve_id("CVE-2009-1572");
  script_name(english:"Quagga Denial of Service Vulnerability");
  desc["english"] = "

  Overview: This host is installed with Quagga for Linux and is prone to
  Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to an assertion error in the BGP daemon while handling
  an AS path containing multiple 4 byte AS numbers.

  Impact:
  Successful exploitation will let the attacker crash the daemon by advertising
  specially crafted AS paths and cause denial of service.

  Impact level: Application

  Affected Software/OS:
  Quagga version 0.99.11 and prior

  Fix:
  Apply the security update with the patch 0.99.10-1lenny2 for stable versions.
  Apply the security update with the patch 0.99.11-2 for unstable versions.
  http://www.debian.org/security/2009/dsa-1788

  *****
  NOTE: Please ignore the warning if patch has been already applied.
  *****

  References:
  http://osvdb.org/54200
  http://secunia.com/advisories/34999
  http://www.openwall.com/lists/oss-security/2009/05/01/2

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Quagga");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Denial of Service");
  script_dependencies("gb_quagga_detect.nasl");
  script_require_keys("Quagga/Ver");
  exit(0);
}


include("version_func.inc");

quaggaVer = get_kb_item("Quagga/Ver");
if(quaggaVer == NULL){
  exit(0);
}

# Grep for Quagga version 0.99.11 and prior.
if(version_is_less_equal(version:quaggaVer, test_version:"0.99.11")){
  security_warning(0);
}
