###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_python_intr_overflow_vuln_win.nasl 0463 2008-11-13 09:41:19Z nov $
#
# Python Multiple Integer Overflow Vulnerabilities (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800056);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5031");
  script_name(english:"Python Multiple Integer Overflow Vulnerabilities (Win)");
  desc["english"] = "

  Overview: This host has Python installed and is prone to integer overflow
  vulnerability.

  Vulnerability Insight:
  The flaw exists due the the way it handles large integer values in the
  tabsize arguments as input to expandtabs methods (string_expandtabs and
  nicode_expandtabs) in stringobject.c and unicodeobject.c.

  Impact:
  Remote exploitation will allow execution of arbitrary code via large number
  of integer values to modules.

  Impact Level: Application

  Affected Software/OS:
  Python 2.5.2 on Windows.

  Fix: No solution/patch is avilable as on 13th November, 2008. Information
  Regarding this issue will updated once the solution details are available.
  For updates refer, http://www.python.org/

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.5
  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of Python");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Misc.");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!(get_kb_item("SMB/WindowsVersion"))){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach entry (registry_enum_keys(key:key))
{
  pyName = registry_get_sz(key:key + entry, item:"DisplayName");
  if("Python" >< pyName)
  {
    pyVer = eregmatch(pattern:"[0-9.]+", string:pyName);
    if(pyVer != NULL)
    {
      if(version_is_equal(version:pyVer[0], test_version:"2.5.2")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
