###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_noip_dns_bof_vuln.nasl 568 2008-12-17 11:57:46Z dec $
#
# No-IP DUC Remote code execution vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800084);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5297");
  script_name(english:"No-IP DUC Remote code execution vulnerability");
  desc["english"] = "

  Overview: This host has No-IP DUC installed and is prone to remote code
  execution vulnerability.

  Vulnerability Insight:
  The flaw is due to DNS poisoning in the function GetNextLine which fails
  to do length check.

  Impact:
  Successful attack could result in remote DNS servers to execute arbitrary
  code via a crafted DNS response.

  Impact Level: Application

  Affected Software/OS:
  No-IP DUC 2.1.7 and prior on Linux

  Fix: Upgrade to latest version of No-IP DUC,
  http://www.no-ip.com/downloads.php

  References:
  http://www.milw0rm.com/exploits/7151
  http://www.openwall.com/lists/oss-security/2008/11/21/15

  CVSS Score:
    CVSS Base Score     : 7.6 (AV:N/AC:H/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.0
  Risk factor : High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the version of No-IP");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2008 Intevation GmbH");
  script_family(english:"Buffer overflow");
  exit(0);
}


include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

binFile = find_bin(prog_name:"noip2", sock:sock);
foreach binaryFile (binFile)
{
  noipVer = get_bin_version(full_prog_name:chomp(binaryFile),
                            version_argv:"-h",
                            ver_pattern:"Version Linux-([0-9.]+)", sock:sock);
  if(noipVer[1] != NULL)
  {
    if(version_is_less_equal(version:noipVer[1], test_version:"2.1.7")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
