###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for libsamplerate MDVSA-2008:238 (libsamplerate)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830473);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:238");
  script_cve_id("CVE-2008-5008");
  script_name(english: "Mandriva Update for libsamplerate MDVSA-2008:238 (libsamplerate)");
  desc["english"] = "

  Vulnerability Insight:

  A buffer overflow was found by Russell O'Conner in the libsamplerate
  library versions prior to 0.1.4 that could possibly lead to the
  execution of arbitrary code via a specially crafted audio file
  (CVE-2008-5008).
  
  The updated packages have been patched to prevent this issue.

  Affected Software/OS:
  libsamplerate on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-12/msg00006.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of libsamplerate");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"libsamplerate0", rpm:"libsamplerate0~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate-devel", rpm:"libsamplerate-devel~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate-progs", rpm:"libsamplerate-progs~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate", rpm:"libsamplerate~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64samplerate0", rpm:"lib64samplerate0~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64samplerate-devel", rpm:"lib64samplerate-devel~0.1.3~0.pre6.3.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libsamplerate0", rpm:"libsamplerate0~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate-devel", rpm:"libsamplerate-devel~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate-progs", rpm:"libsamplerate-progs~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsamplerate", rpm:"libsamplerate~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64samplerate0", rpm:"lib64samplerate0~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64samplerate-devel", rpm:"lib64samplerate-devel~0.1.3~0.pre6.3.1mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}