###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for dovecot MDVSA-2008:232 (dovecot)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830496);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:232");
  script_cve_id("CVE-2008-4577", "CVE-2008-4578");
  script_name(english: "Mandriva Update for dovecot MDVSA-2008:232 (dovecot)");
  desc["english"] = "

  Vulnerability Insight:

  The ACL plugin in dovecot prior to version 1.1.4 treated negative
  access rights as though they were positive access rights, which allowed
  attackers to bypass intended access restrictions (CVE-2008-4577).
  
  The ACL plugin in dovecot prior to version 1.1.6 allowed attackers to
  bypass intended access restrictions by using the 'k' right to create
  unauthorized 'parent/child/child' mailboxes (CVE-2008-4578).
  
  In addition, two bugs were discovered in the dovecot package shipped
  with Mandriva Linux 2009.0. The default permissions on the dovecot.conf
  configuration file were too restrictive, which prevents the use of
  dovecot's 'deliver' command as a non-root user. Secondly, dovecot
  should not start until after ntpd, if ntpd is active, because if ntpd
  corrects the time backwards while dovecot is running, dovecot will
  quit automatically, with the log message 'Time just moved backwards
  by X seconds. This might cause a lot of problems, so I'll just kill
  myself now.' The update resolves both these problems. The default
  permissions on dovecot.conf now allow the 'deliver' command to read the
  file. Note that if you edited dovecot.conf at all prior to installing
  the update, the new permissions may not be applied. If you find the
  'deliver' command still does not work following the update, please
  run these commands as root:
  
  # chmod 0640 /etc/dovecot.conf
  # chown root:mail /etc/dovecot.conf
  
  Dovecot's initialization script now configures it to start after the
  ntpd service, to ensure ntpd resetting the clock does not interfere
  with Dovecot operation.
  
  This package corrects the above-noted bugs and security issues by
  upgrading to the latest dovecot 1.1.6, which also provides additional
  bug fixes.

  Affected Software/OS:
  dovecot on Mandriva Linux 2009.0,
  Mandriva Linux 2009.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00016.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of dovecot");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2009.0")
{

  if(isrpmvuln(pkg:"dovecot", rpm:"dovecot~1.1.6~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dovecot-devel", rpm:"dovecot-devel~1.1.6~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dovecot-plugins-gssapi", rpm:"dovecot-plugins-gssapi~1.1.6~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"dovecot-plugins-ldap", rpm:"dovecot-plugins-ldap~1.1.6~0.1mdv2009.0", rls:"MNDK_2009.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}