###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for rsh MDVSA-2008:191 (rsh)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830694);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:191");
  script_cve_id("CVE-2004-0175");
  script_name(english: "Mandriva Update for rsh MDVSA-2008:191 (rsh)");
  desc["english"] = "

  Vulnerability Insight:

  A vulnerability in the rcp protocol was discovered that allows a
  server to instruct a client to write arbitrary files outside of the
  current directory, which could potentially be a security concern if
  a user used rcp to copy files from a malicious server (CVE-2004-0175).
  
  This issue was originally corrected in MDKSA-2005:100, but the patch
  had not been applied to the development tree, so released packages
  after that date did not have the fix applied.
  
  This update also corrects an issue where rexecd did not honor settings
  in /etc/security/limits if pam_limits was in use.

  Affected Software/OS:
  rsh on Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64,
  Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00008.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of rsh");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~16.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~16.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~16.1mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~16.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~18.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~19.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~18.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~19.2mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"rsh", rpm:"rsh~0.17~20.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"rsh-server", rpm:"rsh-server~0.17~20.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}