###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for kernel MDVSA-2008:044 (kernel)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830517);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:044");
  script_cve_id("CVE-2007-5500", "CVE-2007-5501", "CVE-2007-6206", "CVE-2008-0001", "CVE-2008-0007", "CVE-2008-0600");
  script_name(english: "Mandriva Update for kernel MDVSA-2008:044 (kernel)");
  desc["english"] = "

  Vulnerability Insight:

  The wait_task_stopped function in the Linux kernel before 2.6.23.8
  checks a TASK_TRACED bit instead of an exit_state value, which
  allows local users to cause a denial of service (machine crash) via
  unspecified vectors.  NOTE: some of these details are obtained from
  third party information. (CVE-2007-5500)
  
  The tcp_sacktag_write_queue function in the Linux kernel 2.6.21 through
  2.6.23.7 allowed remote attackers to cause a denial of service (crash)
  via crafted ACK responses that trigger a NULL pointer dereference
  (CVE-2007-5501).
  
  The do_corefump function in fs/exec.c in the Linux kernel prior to
  2.6.24-rc3 did not change the UID of a core dump file if it exists
  before a root process creates a core dump in the same location, which
  could possibly allow local users to obtain sensitive information
  (CVE-2007-6206).
  
  VFS in the Linux kernel before 2.6.22.16 performed tests of access
  mode by using the flag variable instead of the acc_mode variable,
  which could possibly allow local users to bypass intended permissions
  and remove directories (CVE-2008-0001).
  
  The Linux kernel prior to 2.6.22.17, when using certain drivers
  that register a fault handler that does not perform range checks,
  allowed local users to access kernel memory via an out-of-range offset
  (CVE-2008-0007).
  
  A flaw in the vmsplice system call did not properly verify address
  arguments passed by user-space processes, which allowed local
  attackers to overwrite arbitrary kernel memory and gain root privileges
  (CVE-2008-0600).
  
  Mandriva urges all users to upgrade to these new kernels immediately
  as the CVE-2008-0600 flaw is being actively exploited.  This issue
  only affects 2.6.17 and newer Linux kernels, so neither Corporate
  3.0 nor Corporate 4.0 are affected.
  
  Additionally, this kernel updates the version from 2.6.22.12 to
  2.6.22.18 and fixes numerous other bugs, including:
  
  - fix freeze when ejecting a cm40x0 PCMCIA card
  - fix crash on unloading netrom
  - fixes alsa-related sound issues on Dell XPS M1210 and M1330 models
  - the HZ value was increased on the laptop kernel to increase
  interactivity and reduce latency
  - netfilter ipset, psd, and ifwlog support was re-enabled
  - unionfs was reverted to a working 1.4 branch that is less buggy
  
  To update your kernel, please follow the directions located at:
  
  http://www.mandriva.com/en/security/kernelupdate

  Affected Software/OS:
  kernel on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00019.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop", rpm:"kernel-desktop~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop-devel", rpm:"kernel-desktop-devel~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop-devel-latest", rpm:"kernel-desktop-devel-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop-latest", rpm:"kernel-desktop-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop586", rpm:"kernel-desktop586~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop586-devel", rpm:"kernel-desktop586-devel~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop586-devel-latest", rpm:"kernel-desktop586-devel-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-desktop586-latest", rpm:"kernel-desktop586-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-doc", rpm:"kernel-doc~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-laptop", rpm:"kernel-laptop~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-laptop-devel", rpm:"kernel-laptop-devel~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-laptop-devel-latest", rpm:"kernel-laptop-devel-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-laptop-latest", rpm:"kernel-laptop-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-server", rpm:"kernel-server~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-server-devel", rpm:"kernel-server-devel~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-server-devel-latest", rpm:"kernel-server-devel-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-server-latest", rpm:"kernel-server-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source", rpm:"kernel-source~2.6.22.18~1mdv~1~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel-source-latest", rpm:"kernel-source-latest~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"kernel", rpm:"kernel~2.6.22.18~1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}