###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for emacs MDVSA-2008:034 (emacs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830453);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVSA", value: "2008:034");
  script_cve_id("CVE-2007-5795", "CVE-2007-6109");
  script_name(english: "Mandriva Update for emacs MDVSA-2008:034 (emacs)");
  desc["english"] = "

  Vulnerability Insight:

  The hack-local-variable function in Emacs 22 prior to version 22.2,
  when enable-local-variables is set to ':safe', did not properly search
  lists of unsafe or risky variables, which could allow user-assisted
  attackers to bypass intended restrictions and modify critical
  program variables via a file containing a Local variables declaration
  (CVE-2007-5795; only affects Mandriva Linux 2008.0).
  
  A stack-based buffer overflow in emacs could allow user-assisted
  attackers to cause an application crash or possibly have other
  unspecified impacts via a large precision value in an integer format
  string specifier to the format function (CVE-2007-6109).
  
  The updated packages have been patched to correct these issues.

  Affected Software/OS:
  emacs on Mandriva Linux 2007.0,
  Mandriva Linux 2007.0/X86_64,
  Mandriva Linux 2007.1,
  Mandriva Linux 2007.1/X86_64,
  Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-02/msg00004.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of emacs");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2007.1")
{

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-X11", rpm:"emacs-X11~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-doc", rpm:"emacs-doc~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-leim", rpm:"emacs-leim~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~21.4~26.2mdv2007.1", rls:"MNDK_2007.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2007.0")
{

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-X11", rpm:"emacs-X11~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-doc", rpm:"emacs-doc~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-leim", rpm:"emacs-leim~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~21.4~26.2mdv2007.0", rls:"MNDK_2007.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"emacs", rpm:"emacs~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-common", rpm:"emacs-common~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-doc", rpm:"emacs-doc~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-el", rpm:"emacs-el~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-gtk", rpm:"emacs-gtk~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-leim", rpm:"emacs-leim~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"emacs-nox", rpm:"emacs-nox~22.1~5.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}