###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for pulseaudio MDVA-2008:110 (pulseaudio)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830536);
  script_version("$Revision: 1.0 $");
  script_xref(name: "MDVA", value: "2008:110");
  script_cve_id("");
  script_name(english: "Mandriva Update for pulseaudio MDVA-2008:110 (pulseaudio)");
  desc["english"] = "

  Vulnerability Insight:

  The pulseaudio package shipped with Mandriva 2008 Spring does not
  remember a default device setting across sessions. If a user were to
  use pavucontrol to select an alternate default device, it will only
  work for that session. Logging out then back in again will revert
  back to the system default.
  
  A separate issue also prevents the settings in client.conf from working
  when pulse is started under an X11 session (which is the default way
  of starting pulseaudio). This is because the client.conf has a lower
  priority than the X11 root window properties.
  
  This update addresses both these issues, but please note that
  pulseaudio remembers the per-stream device preferences, so only
  new streams that have not been played before will routed to any
  new default device you pick. This can be remedied by removing the
  ~/.pulse/volume-restore.table file before logging in to a graphical
  session or by moving the individual streams manually in pavucontrol
  as required.

  Affected Software/OS:
  pulseaudio on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-07/msg00045.php

  Risk factor: High";

  script_description(english:desc["english"]);
  script_summary(english:"Check for the Version of pulseaudio");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"Copyright (C) 2009 Intevation GmbH");
  script_family(english:"Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"libpulseaudio0", rpm:"libpulseaudio0~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulseaudio-devel", rpm:"libpulseaudio-devel~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulsecore5", rpm:"libpulsecore5~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulseglib20", rpm:"libpulseglib20~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libpulsezeroconf0", rpm:"libpulsezeroconf0~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio", rpm:"pulseaudio~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-esound-compat", rpm:"pulseaudio-esound-compat~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-bluetooth", rpm:"pulseaudio-module-bluetooth~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-gconf", rpm:"pulseaudio-module-gconf~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-jack", rpm:"pulseaudio-module-jack~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-lirc", rpm:"pulseaudio-module-lirc~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-x11", rpm:"pulseaudio-module-x11~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-module-zeroconf", rpm:"pulseaudio-module-zeroconf~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"pulseaudio-utils", rpm:"pulseaudio-utils~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio0", rpm:"lib64pulseaudio0~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseaudio-devel", rpm:"lib64pulseaudio-devel~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulsecore5", rpm:"lib64pulsecore5~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulseglib20", rpm:"lib64pulseglib20~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64pulsezeroconf0", rpm:"lib64pulsezeroconf0~0.9.9~7.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}